#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//underwater Algae thinguiesMod01.fsh   by   Bagdaja   
//https://www.shadertoy.com/view/X3fcDB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float rand(vec2 co){
    return fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453);
}


// I got this from https://iquilezles.org/articles/palettes/ 
// and used 
// http://dev.thi.ng/gradients/
vec3 grad( in float t)
{
    vec3 a = vec3(0.586, 0.778, 0.852);
    vec3 b = vec3(0.780, 0.090, 0.992);
    vec3 c = vec3(1.253, 0.752, 1.184);
    vec3 d = vec3(1.562, 2.669, 1.422);

    return a + b*cos( 6.283185*(c*t+d) );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float resProp = iResolution.x/iResolution.y;
    
    //normalize
    vec2 uv = (fragCoord*2.-iResolution.xy)/iResolution.y; 
    
    //how many ropes
    const float thCount=89.;
    
    
    float height = (0.5+uv.y*0.5);
    
    float str = 0.;
    float dustStr = 0.;
    vec3 threadCol;
    vec3 dustCol;
    
    
    for(float i=0.; i<thCount ;i+=1.0){
    
        float depth = 1.- i/thCount; 
        
        //2 random values depending on the i
        float randI = rand(vec2(i));
        float randI2 = rand(vec2(randI));
        
        
        float randFreqAu = 0.3+randI*0.6;
        float fi1 = -uv.y+iTime*randFreqAu*0.23+i;
        float fi2 = -uv.y+iTime*randFreqAu*0.335+i;

        
        
        
        float amp = (1.-depth) // the deeper the rope the lesser the amplitude, because the rope is smaller
        
        *(0.5-pow(uv.y,2.)) //the middle parts of the rope can oscilate even more, thus the amplitude is increased (test different heights, it's cool ;) )
        
        *0.8*(randI*cos(fi1)+(1.-randI)*-sin(fi2)); //the peaks of the sin+cos wave are reduced 
                                                    //(used the derivatives of the wave equation for that) 
        


        float x = resProp*(randI*2.-1. ) //finding a random x coord depending on the resolution
        
        +(randI*sin(fi1)+(1.-randI)*cos(fi2))*amp; // the actual wave equation, multiplied by the amp
        
        
        //str of the rope color
        str = max(str,
        pow(1.2-depth*0.6,2.) // the depth of the rope makes it more dark, simulating like shade and so
        *smoothstep(0.,1.,1.-height) //the higher part of the image is also darkes
        *smoothstep(0.97+depth*0.02,1.,1.-abs(uv.x-x)) // the first param of the smoothstep will make the deeper ropes thinner
        );
        
        threadCol = str*grad(.5+0.5*sin(iTime*(depth+0.1)+depth)); //I get the color depending on the depth and the time
            

        dustStr = max(dustStr,
        smoothstep(0.99,1.,1.-distance(uv,vec2((randI*2.-1.)*resProp+0.1*(randI*sin(randI*iTime)+(1.-randI)*cos(randI2*iTime)),mod(iTime*randI2*0.1+randI2,1.2)*2.-1.1)))
        ); //this is just the random dust particles
        
        dustCol = dustStr*vec3(1.); 
    }
        if(dustStr>str){
            fragColor = vec4(dustCol,1.);
      //      return;
        }
        fragColor.xy = threadCol.xy;
        fragColor.z = threadCol.z+0.3;
      //  return;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

